procedure $see_resids
argument local string scalar runno
argument local namelist freqs
argument local numeric series by case agelower = list(16,25,16,18,20,25,30,35,40,45,50,55,60,62,65,70)
argument local numeric series by case ageupper = list(80,80,17,19,24,29,34,39,44,49,54,59,61,64,69,80)
argument local string scalar db_path = ""
argument local string scalar pro_path = ""
block

   if missing(location(@open.db,"CPSREV"))
      open <ac re> file(local'db_path+"cpscovar_rev.db") as cpsrev
      -local'cpsrevopened = TRUE
   else
      -local'cpsrevopened = FALSE
   end if

   if missing(location(@open.db,"LOUT"))
      open <ac re> file(local'db_path+"lfpr_run"+runno+".db") as lout
      -local'loutopened = TRUE
   else
      -local'loutopened = FALSE
   end if

   local'filename = "$TMPDIR/mg_"+$USERID()+"_"+left(system("date +'%Y%m%d%H%M%S%N'"),20)+".db"

   cload file(local'pro_path+"workagg.pro")
   $workagg local'freqs, local'agelower, local'ageupper, local'runno, local'filename
   open <ac re> file(trim(local'filename)) as todb

   symbolsize scircle 7

   device graphics postp
   page margins horizontal 0, vertical 0

   glue null
   overwrite on

   map color postscript C1 "black", C2 "royalblue", C3 "black", C4 "red", &&
                        C5 "slategray", C6 "Rosybrown", C7 "Lemonchiffon", C8 "lavender", &&
                        C9 "silver",  c10 "3F3F3F", c11 "5F5F5F", c12 "7F7F7F", c14 "9F9F9F"

   legend contents description off 
   legend size small


   page title #2 null
   page divi rows 3, columns 1

   loop for sfreq in freqs
      execute "freq "+name(sfreq)
      -local'ssfreq = (if name(sfreq) eq "M" then "" else name(sfreq))
      -local'per = (if name(sfreq) eq "M" then 12 &&
                    else (if name(sfreq) eq "Q" then 4 &&
                          else (if name(sfreq) eq "A" then 1 else 0)))


      device graphics postp
      open <ac over; kind graphic> file("run"+local'runno+"resraw_"+name(sfreq)+".ps") as ageresids.ps
      channel graphics ageresids.ps

      case 1 to 60
      -local'clabels = string(n-1)
      image case axis "<series:local'clabels>"

      case 1 to *
      batch infobar left .05, right .95
      batch #1 color c1, bstyle solid, shading paint, draw bar, sseparation 3
      batch #2 color c1, bstyle solid, shading paint, draw bar, sseparation 3
      batch #3 color c1, bstyle solid, shading paint, draw bar, sseparation 3

      plot style solid

      date 1976:1 to 2016:1-1
      page division rows 4, columns 2
      loop for age = 16 to 79
         if exists(lout'arresm&age&sfreq)
            cell(1,1)
         else
            cell(1,1 to 2)
         end if     

         graph 
            date 1976 to *
            legend appear on, size xsmall, font f10
            legend division rows 1, column auto
            tick label size xsmall, font f10
            title #1 font f10, size xsmall, text "Raw Residual (Men, Age "+string(age)+")", color c1
            if exists(lout'arresm&age&sfreq)
               if exists(lout'res2m&age&sfreq)
                  if exists(lout'stage2agem&sfreq)
                     if (lout'stage2agem&sfreq[age-15] eq 1)        
                        data lout'resm&age&sfreq <plot name "Overall Residual", color c1>, &&
                             lout'arresm&age&sfreq <plot name "AR(1) Innovation (rho: "+numfmt(lout'rhom&sfreq[age-15],5,3)+")", color c4>, &&
                             lout'res2m&age&sfreq <plot name "2nd stage Innovation", color c2>
                     else
                        data lout'resm&age&sfreq <plot name "Overall Residual", color c1>, &&
                             lout'arresm&age&sfreq <plot name "AR(1) Innovation (rho: "+numfmt(lout'rhom&sfreq[age-15],5,3)+")", color c4>
                     end if
                  else
                     data lout'resm&age&sfreq <plot name "Overall Residual", color c1>, &&
                          lout'arresm&age&sfreq <plot name "AR(1) Innovation (rho: "+numfmt(lout'rhom&sfreq[age-15],5,3)+")", color c4>, &&
                          lout'res2m&age&sfreq <plot name "2nd stage Innovation", color c2>
                  end if
               else
                  data lout'resm&age&sfreq <plot name "Overall Residual", color c1>, &&
                       lout'arresm&age&sfreq <plot name "AR(1) Innovation (rho: "+numfmt(lout'rhom&sfreq[age-15],5,3)+")", color c4>
               end if
            else if exists(lout'res2m&age&sfreq)
               if exists(lout'stage2agem&sfreq)
                  if (lout'stage2agem&sfreq[age-15] eq 1)
                     data lout'resm&age&sfreq <plot name "Overall Residual", color c9, thickness xthin>, &&
                          mave(lout'resm&age&sfreq,local'per) <plot name "Overall Residual (MA "+string(local'per)+"-period)", color c1, thickness thin>, &&
                          lout'res2m&age&sfreq <plot name "2nd stage Innovation", color c16, thickness xthin>, &&
                          mave(lout'res2m&age&sfreq,local'per) <plot name "2nd stage Innovation (MA "+string(local'per)+"-period)", color c2, thickness thin>
                  else
                     data lout'resm&age&sfreq <plot name "Overall Residual", color c9, thickness xthin>, &&
                          mave(lout'resm&age&sfreq,local'per) <plot name "Overall Residual (MA "+string(local'per)+"-period)", color c1, thickness thin>
                  end if
               else
                  data lout'resm&age&sfreq <plot name "Overall Residual", color c9, thickness xthin>, &&
                       mave(lout'resm&age&sfreq,local'per) <plot name "Overall Residual (MA "+string(local'per)+"-period)", color c1, thickness thin>, &&
                       lout'res2m&age&sfreq <plot name "2nd stage Innovation", color c16, thickness xthin>, &&
                       mave(lout'res2m&age&sfreq,local'per) <plot name "2nd stage Innovation (MA "+string(local'per)+"-period)", color c2, thickness thin>
               end if
            else
               data lout'resm&age&sfreq <plot name "Overall Residual", color c9, thickness xthin>, &&
                    mave(lout'resm&age&sfreq,local'per) <plot name "Overall Residual (MA "+string(local'per)+"-period)", color c1, thickness thin>
            end if
         
            draw region <depict axis bottom, color C8,shading paint; glue dot> lout'end_est&sfreq-lmax((26-age),0)*local'per+1 to 2021:1-1
            draw region <depict axis bottom, color C8,shading paint; glue dot> 1950:1 to lout'start_est&sfreq+lmax((age-69),0)*local'per-1
            draw line <depict axis bottom, color C9, placement beginning; glue dot> &&
               (lout'start_est&sfreq+lmax((age-69),0)*local'per,@left.axis.min) to (lout'start_est&sfreq+lmax((age-69),0)*local'per,@left.axis.max)
            draw line <depict axis bottom, color C9, placement beginning; glue dot> &&
               (lout'end_est&sfreq-lmax((26-age),0)*local'per+1,@left.axis.min) to (lout'end_est&sfreq-lmax((26-age),0)*local'per+1,@left.axis.max)
            depict grid on, axis left
            draw marking at 0
         end graph      

         if exists(lout'arresm&age&sfreq)
            -local'p1 = (if t lt 1980:1 then lout'arresm&age&sfreq else ND)
            -local'p2 = (if t lt 1980:1 then ND else (if t lt 1991:1 then lout'arresm&age&sfreq else ND))
            -local'p3 = (if t lt 1991:1 then ND else (if t lt 2002:1 then lout'arresm&age&sfreq else ND))
            -local'p4 = (if t lt 2002:1 then ND else (if t lt 2008:1 then lout'arresm&age&sfreq else ND))
            -local'p5 = (if t lt 2008:1 then ND else lout'arresm&age&sfreq)

            cell(1,2)
            graph 
               date 1976 to *
               legend appear on, size xsmall, font f10
               legend division rows 2, column auto
               tick label size xsmall, font f10
               title #1 font f10, size xsmall, text "Raw Residual vs. LFPR (Men, Age "+string(age)+")", color c1
               data local'p1 <scatter name "*-'79", color c1, draw eachvalue, symbol scircle>, &&
                    local'p2 <scatter name "'80-'90", color c4, draw eachvalue, symbol scircle>, &&
                    local'p3 <scatter name "'91-'01", color c2, draw eachvalue, symbol scircle>, &&
                    local'p4 <scatter name "'02-'07", color c15, draw eachvalue, symbol scircle>, &&
                    local'p5 <scatter name "'08-*", color c11, draw eachvalue, symbol scircle> &&
                    vs lout'id(lout'lfpname)&_predm&age&sfreq
                    -- cpsrev'id(lout'lfpname+"m_a"+string(age)+local'ssfreq)
         
               depict grid on, axis left
               draw marking at 0
            end graph  
         end if

         -local'p1 = (if t lt 1980:1 then lout'resm&age&sfreq else ND)
         -local'p2 = (if t lt 1980:1 then ND else (if t lt 1991:1 then lout'resm&age&sfreq else ND))
         -local'p3 = (if t lt 1991:1 then ND else (if t lt 2002:1 then lout'resm&age&sfreq else ND))
         -local'p4 = (if t lt 2002:1 then ND else (if t lt 2008:1 then lout'resm&age&sfreq else ND))
         -local'p5 = (if t lt 2008:1 then ND else lout'resm&age&sfreq)

         cell(2,1 to 2)
         graph 
            date 1976 to *
            legend appear on, size xsmall, font f10
            legend division rows 2, column auto
            tick label size xsmall, font f10
            title #1 font f10, size xsmall, text "Raw Residual vs. LFPR (Men, Age "+string(age)+")", color c1
            if exists(lout'arresm&age&sfreq)
               if exists(lout'res2m&age&sfreq)
                  if exists(lout'stage2agem&sfreq)
                     if (lout'stage2agem&sfreq[age-15] eq 1)        
                        data local'p1 <scatter name "*-'79", color c1, draw eachvalue, symbol scircle>, &&
                             local'p2 <scatter name "'80-'90", color c4, draw eachvalue, symbol scircle>, &&
                             local'p3 <scatter name "'91-'01", color c2, draw eachvalue, symbol scircle>, &&
                             local'p4 <scatter name "'02-'07", color c15, draw eachvalue, symbol scircle>, &&
                             local'p5 <scatter name "'08-*", color c11, draw eachvalue, symbol scircle>, &&
                             local'p1 <scatter color c1, draw line, style solid, legend off>, &&
                             local'p2 <scatter color c4, draw line, style solid, legend off>, &&
                             local'p3 <scatter color c2, draw line, style solid, legend off>, &&
                             local'p4 <scatter color c15, draw line, style solid, legend off>, &&
                             local'p5 <scatter color c11, draw line, style solid, legend off> &&
                             vs lout'id(lout'lfpname)&_predm&age&sfreq
                     else
                        data local'p1 <scatter name "*-'79", color c1, draw eachvalue, symbol scircle>, &&
                             local'p2 <scatter name "'80-'90", color c4, draw eachvalue, symbol scircle>, &&
                             local'p3 <scatter name "'91-'01", color c2, draw eachvalue, symbol scircle>, &&
                             local'p4 <scatter name "'02-'07", color c15, draw eachvalue, symbol scircle>, &&
                             local'p5 <scatter name "'08-*", color c11, draw eachvalue, symbol scircle>, &&
                             local'p1 <scatter color c1, draw line, style solid, legend off>, &&
                             local'p2 <scatter color c4, draw line, style solid, legend off>, &&
                             local'p3 <scatter color c2, draw line, style solid, legend off>, &&
                             local'p4 <scatter color c15, draw line, style solid, legend off>, &&
                             local'p5 <scatter color c11, draw line, style solid, legend off> &&
                             vs lout'id(lout'lfpname)&_predm&age&sfreq
                     end if
                  else
                     data local'p1 <scatter name "*-'79", color c1, draw eachvalue, symbol scircle>, &&
                          local'p2 <scatter name "'80-'90", color c4, draw eachvalue, symbol scircle>, &&
                          local'p3 <scatter name "'91-'01", color c2, draw eachvalue, symbol scircle>, &&
                          local'p4 <scatter name "'02-'07", color c15, draw eachvalue, symbol scircle>, &&
                          local'p5 <scatter name "'08-*", color c11, draw eachvalue, symbol scircle>, &&
                          local'p1 <scatter color c1, draw line, style solid, legend off>, &&
                          local'p2 <scatter color c4, draw line, style solid, legend off>, &&
                          local'p3 <scatter color c2, draw line, style solid, legend off>, &&
                          local'p4 <scatter color c15, draw line, style solid, legend off>, &&
                          local'p5 <scatter color c11, draw line, style solid, legend off> &&
                          vs lout'id(lout'lfpname)&_predm&age&sfreq
                  end if
               else
                  data local'p1 <scatter name "*-'79", color c1, draw eachvalue, symbol scircle>, &&
                       local'p2 <scatter name "'80-'90", color c4, draw eachvalue, symbol scircle>, &&
                       local'p3 <scatter name "'91-'01", color c2, draw eachvalue, symbol scircle>, &&
                       local'p4 <scatter name "'02-'07", color c15, draw eachvalue, symbol scircle>, &&
                       local'p5 <scatter name "'08-*", color c11, draw eachvalue, symbol scircle>, &&
                       local'p1 <scatter color c1, draw line, style solid, legend off>, &&
                       local'p2 <scatter color c4, draw line, style solid, legend off>, &&
                       local'p3 <scatter color c2, draw line, style solid, legend off>, &&
                       local'p4 <scatter color c15, draw line, style solid, legend off>, &&
                       local'p5 <scatter color c11, draw line, style solid, legend off> &&
                       vs lout'id(lout'lfpname)&_predm&age&sfreq
               end if
            else if exists(lout'res2m&age&sfreq)
               if exists(lout'stage2agem&sfreq)
                  if (lout'stage2agem&sfreq[age-15] eq 1)
                     data local'p1 <scatter name "*-'79", color c1, draw eachvalue, symbol scircle>, &&
                          local'p2 <scatter name "'80-'90", color c4, draw eachvalue, symbol scircle>, &&
                          local'p3 <scatter name "'91-'01", color c2, draw eachvalue, symbol scircle>, &&
                          local'p4 <scatter name "'02-'07", color c15, draw eachvalue, symbol scircle>, &&
                          local'p5 <scatter name "'08-*", color c11, draw eachvalue, symbol scircle>, &&
                          local'p1 <scatter color c1, draw line, style solid, legend off>, &&
                          local'p2 <scatter color c4, draw line, style solid, legend off>, &&
                          local'p3 <scatter color c2, draw line, style solid, legend off>, &&
                          local'p4 <scatter color c15, draw line, style solid, legend off>, &&
                          local'p5 <scatter color c11, draw line, style solid, legend off> &&
                          vs lout'id(lout'lfpname)&_predm&age&sfreq
                  else
                     data local'p1 <scatter name "*-'79", color c1, draw eachvalue, symbol scircle>, &&
                          local'p2 <scatter name "'80-'90", color c4, draw eachvalue, symbol scircle>, &&
                          local'p3 <scatter name "'91-'01", color c2, draw eachvalue, symbol scircle>, &&
                          local'p4 <scatter name "'02-'07", color c15, draw eachvalue, symbol scircle>, &&
                          local'p5 <scatter name "'08-*", color c11, draw eachvalue, symbol scircle>, &&
                          local'p1 <scatter color c1, draw line, style solid, legend off>, &&
                          local'p2 <scatter color c4, draw line, style solid, legend off>, &&
                          local'p3 <scatter color c2, draw line, style solid, legend off>, &&
                          local'p4 <scatter color c15, draw line, style solid, legend off>, &&
                          local'p5 <scatter color c11, draw line, style solid, legend off> &&
                          vs lout'id(lout'lfpname)&_predm&age&sfreq
                  end if
               else
                  data local'p1 <scatter name "*-'79", color c1, draw eachvalue, symbol scircle>, &&
                       local'p2 <scatter name "'80-'90", color c4, draw eachvalue, symbol scircle>, &&
                       local'p3 <scatter name "'91-'01", color c2, draw eachvalue, symbol scircle>, &&
                       local'p4 <scatter name "'02-'07", color c15, draw eachvalue, symbol scircle>, &&
                       local'p5 <scatter name "'08-*", color c11, draw eachvalue, symbol scircle>, &&
                       local'p1 <scatter color c1, draw line, style solid, legend off>, &&
                       local'p2 <scatter color c4, draw line, style solid, legend off>, &&
                       local'p3 <scatter color c2, draw line, style solid, legend off>, &&
                       local'p4 <scatter color c15, draw line, style solid, legend off>, &&
                       local'p5 <scatter color c11, draw line, style solid, legend off> &&
                       vs lout'id(lout'lfpname)&_predm&age&sfreq
               end if
            else
               data local'p1 <scatter name "*-'79", color c1, draw eachvalue, symbol scircle>, &&
                    local'p2 <scatter name "'80-'90", color c4, draw eachvalue, symbol scircle>, &&
                    local'p3 <scatter name "'91-'01", color c2, draw eachvalue, symbol scircle>, &&
                    local'p4 <scatter name "'02-'07", color c15, draw eachvalue, symbol scircle>, &&
                    local'p5 <scatter name "'08-*", color c11, draw eachvalue, symbol scircle>, &&
                    local'p1 <scatter color c1, draw line, style solid, legend off>, &&
                    local'p2 <scatter color c4, draw line, style solid, legend off>, &&
                    local'p3 <scatter color c2, draw line, style solid, legend off>, &&
                    local'p4 <scatter color c15, draw line, style solid, legend off>, &&
                    local'p5 <scatter color c11, draw line, style solid, legend off> &&
                    vs lout'id(lout'lfpname)&_predm&age&sfreq
            end if
         
            depict grid on, axis left
            draw marking at 0
         end graph      

         cell(3,1 to 2)
         graph 
            date 1976 to *
            legend appear on, size xsmall, font f10
            legend division rows 1, column auto
            tick left numeric linear (auto to 1 in auto using lin2)
            tick label size xsmall, font f10
            title #1 font f10, size xsmall, text "Residual Autocorrelations (Men, Age "+string(age)+")", color c1
            if exists(lout'arcorrm&age&sfreq)
               if exists(lout'corr2m&age&sfreq)
                  if exists(lout'stage2agem&sfreq)
                     if (lout'stage2agem&sfreq[age-15] eq 1)
                        data lout'corrm&age&sfreq <batch name "Overall Residual", scolor c13>, &&
                             lout'arcorrm&age&sfreq <batch name "AR(1) Innovation (rho: "+numfmt(lout'rhom&sfreq[age-15],5,3)+")", scolor c4>, &&
                             lout'corr2m&age&sfreq <batch name "2nd stage Innovation", scolor c2>
                        loop for i = 2 to lastvalue(lout'corrsem&age&sfreq)
                           draw line (i-.3,lmax(@left.axis.min,lout'corrm&age&sfreq[i]-2*lout'corrsem&age&sfreq[i])) to &&
                                     (i-.3,lout'corrm&age&sfreq[i]+2*lout'corrsem&age&sfreq[i])
                           if lout'corrm&age&sfreq[i]-2*lout'corrsem&age&sfreq[i] gt @left.axis.min
                              draw line (i-.4,lout'corrm&age&sfreq[i]-2*lout'corrsem&age&sfreq[i]) to (i-.2,lout'corrm&age&sfreq[i]-2*lout'corrsem&age&sfreq[i])
                           end if
                           draw line (i-.4,lout'corrm&age&sfreq[i]+2*lout'corrsem&age&sfreq[i]) to (i-.2,lout'corrm&age&sfreq[i]+2*lout'corrsem&age&sfreq[i])
                           draw line (i,lmax(@left.axis.min,lout'arcorrm&age&sfreq[i]-2*lout'arcorrsem&age&sfreq[i])) to &&
                                     (i,lout'arcorrm&age&sfreq[i]+2*lout'arcorrsem&age&sfreq[i])
                           if lout'arcorrm&age&sfreq[i]-2*lout'arcorrsem&age&sfreq[i] gt @left.axis.min
                              draw line (i-.1,lout'arcorrm&age&sfreq[i]-2*lout'arcorrsem&age&sfreq[i]) to (i+.1,lout'arcorrm&age&sfreq[i]-2*lout'arcorrsem&age&sfreq[i])
                           end if
                           draw line (i-.1,lout'arcorrm&age&sfreq[i]+2*lout'arcorrsem&age&sfreq[i]) to (i+.1,lout'arcorrm&age&sfreq[i]+2*lout'arcorrsem&age&sfreq[i])
                           draw line (i+.3,lmax(@left.axis.min,lout'corr2m&age&sfreq[i]-2*lout'corr2sem&age&sfreq[i])) to &&
                                     (i+.3,lout'corr2m&age&sfreq[i]+2*lout'corr2sem&age&sfreq[i])
                           if lout'corr2m&age&sfreq[i]-2*lout'corr2sem&age&sfreq[i] gt @left.axis.min
                              draw line (i+.2,lout'corr2m&age&sfreq[i]-2*lout'corr2sem&age&sfreq[i]) to (i+.4,lout'corr2m&age&sfreq[i]-2*lout'corr2sem&age&sfreq[i])
                           end if
                           draw line (i+.2,lout'corr2m&age&sfreq[i]+2*lout'corr2sem&age&sfreq[i]) to (i+.4,lout'corr2m&age&sfreq[i]+2*lout'corr2sem&age&sfreq[i])
                        end loop
                     else
                        data lout'corrm&age&sfreq <batch name "Overall Residual", scolor c13>, &&
                             lout'arcorrm&age&sfreq <batch name "AR(1) Innovation (rho: "+numfmt(lout'rhom&sfreq[age-15],5,3)+")", scolor c4>
                        loop for i = 2 to lastvalue(lout'corrsem&age&sfreq)
                           draw line (i-.225,lmax(@left.axis.min,lout'corrm&age&sfreq[i]-2*lout'corrsem&age&sfreq[i])) to &&
                                     (i-.225,lout'corrm&age&sfreq[i]+2*lout'corrsem&age&sfreq[i])
                           if lout'corrm&age&sfreq[i]-2*lout'corrsem&age&sfreq[i] gt @left.axis.min
                              draw line (i-.325,lout'corrm&age&sfreq[i]-2*lout'corrsem&age&sfreq[i]) to (i-.125,lout'corrm&age&sfreq[i]-2*lout'corrsem&age&sfreq[i])
                           end if
                           draw line (i-.325,lout'corrm&age&sfreq[i]+2*lout'corrsem&age&sfreq[i]) to (i-.125,lout'corrm&age&sfreq[i]+2*lout'corrsem&age&sfreq[i])
                           draw line (i+.225,lmax(@left.axis.min,lout'arcorrm&age&sfreq[i]-2*lout'arcorrsem&age&sfreq[i])) to &&
                                     (i+.225,lout'arcorrm&age&sfreq[i]+2*lout'arcorrsem&age&sfreq[i])
                           if lout'arcorrm&age&sfreq[i]-2*lout'arcorrsem&age&sfreq[i] gt @left.axis.min
                              draw line (i+.125,lout'arcorrm&age&sfreq[i]-2*lout'arcorrsem&age&sfreq[i]) to (i+.325,lout'arcorrm&age&sfreq[i]-2*lout'arcorrsem&age&sfreq[i])
                           end if
                           draw line (i+.125,lout'arcorrm&age&sfreq[i]+2*lout'arcorrsem&age&sfreq[i]) to (i+.325,lout'arcorrm&age&sfreq[i]+2*lout'arcorrsem&age&sfreq[i])
                        end loop
                     end if
                  else
                     data lout'corrm&age&sfreq <batch name "Overall Residual", scolor c13>, &&
                          lout'arcorrm&age&sfreq <batch name "AR(1) Innovation (rho: "+numfmt(lout'rhom&sfreq[age-15],5,3)+")", scolor c4>, &&
                          lout'corr2m&age&sfreq <batch name "2nd stage Innovation", scolor c2>
                     loop for i = 2 to lastvalue(lout'corrsem&age&sfreq)
                        draw line (i-.3,lmax(@left.axis.min,lout'corrm&age&sfreq[i]-2*lout'corrsem&age&sfreq[i])) to &&
                                  (i-.3,lout'corrm&age&sfreq[i]+2*lout'corrsem&age&sfreq[i])
                        if lout'corrm&age&sfreq[i]-2*lout'corrsem&age&sfreq[i] gt @left.axis.min
                           draw line (i-.4,lout'corrm&age&sfreq[i]-2*lout'corrsem&age&sfreq[i]) to (i-.2,lout'corrm&age&sfreq[i]-2*lout'corrsem&age&sfreq[i])
                        end if
                        draw line (i-.4,lout'corrm&age&sfreq[i]+2*lout'corrsem&age&sfreq[i]) to (i-.2,lout'corrm&age&sfreq[i]+2*lout'corrsem&age&sfreq[i])
                        draw line (i,lmax(@left.axis.min,lout'arcorrm&age&sfreq[i]-2*lout'arcorrsem&age&sfreq[i])) to &&
                                  (i,lout'arcorrm&age&sfreq[i]+2*lout'arcorrsem&age&sfreq[i])
                        if lout'arcorrm&age&sfreq[i]-2*lout'arcorrsem&age&sfreq[i] gt @left.axis.min
                           draw line (i-.1,lout'arcorrm&age&sfreq[i]-2*lout'arcorrsem&age&sfreq[i]) to (i+.1,lout'arcorrm&age&sfreq[i]-2*lout'arcorrsem&age&sfreq[i])
                        end if
                        draw line (i-.1,lout'arcorrm&age&sfreq[i]+2*lout'arcorrsem&age&sfreq[i]) to (i+.1,lout'arcorrm&age&sfreq[i]+2*lout'arcorrsem&age&sfreq[i])
                        draw line (i+.3,lmax(@left.axis.min,lout'corr2m&age&sfreq[i]-2*lout'corr2sem&age&sfreq[i])) to &&
                                  (i+.3,lout'corr2m&age&sfreq[i]+2*lout'corr2sem&age&sfreq[i])
                        if lout'corr2m&age&sfreq[i]-2*lout'corr2sem&age&sfreq[i] gt @left.axis.min
                           draw line (i+.2,lout'corr2m&age&sfreq[i]-2*lout'corr2sem&age&sfreq[i]) to (i+.4,lout'corr2m&age&sfreq[i]-2*lout'corr2sem&age&sfreq[i])
                        end if
                        draw line (i+.2,lout'corr2m&age&sfreq[i]+2*lout'corr2sem&age&sfreq[i]) to (i+.4,lout'corr2m&age&sfreq[i]+2*lout'corr2sem&age&sfreq[i])
                     end loop
                  end if
               else
                  data lout'corrm&age&sfreq <batch name "Overall Residual", scolor c13>, &&
                       lout'arcorrm&age&sfreq <batch name "AR(1) Innovation (rho: "+numfmt(lout'rhom&sfreq[age-15],5,3)+")", scolor c4>
                  loop for i = 2 to lastvalue(lout'corrsem&age&sfreq)
                     draw line (i-.225,lmax(@left.axis.min,lout'corrm&age&sfreq[i]-2*lout'corrsem&age&sfreq[i])) to &&
                               (i-.225,lout'corrm&age&sfreq[i]+2*lout'corrsem&age&sfreq[i])
                     if lout'corrm&age&sfreq[i]-2*lout'corrsem&age&sfreq[i] gt @left.axis.min
                        draw line (i-.325,lout'corrm&age&sfreq[i]-2*lout'corrsem&age&sfreq[i]) to (i-.125,lout'corrm&age&sfreq[i]-2*lout'corrsem&age&sfreq[i])
                     end if
                     draw line (i-.325,lout'corrm&age&sfreq[i]+2*lout'corrsem&age&sfreq[i]) to (i-.125,lout'corrm&age&sfreq[i]+2*lout'corrsem&age&sfreq[i])
                     draw line (i+.225,lmax(@left.axis.min,lout'arcorrm&age&sfreq[i]-2*lout'arcorrsem&age&sfreq[i])) to &&
                               (i+.225,lout'arcorrm&age&sfreq[i]+2*lout'arcorrsem&age&sfreq[i])
                     if lout'arcorrm&age&sfreq[i]-2*lout'arcorrsem&age&sfreq[i] gt @left.axis.min
                        draw line (i+.125,lout'arcorrm&age&sfreq[i]-2*lout'arcorrsem&age&sfreq[i]) to (i+.325,lout'arcorrm&age&sfreq[i]-2*lout'arcorrsem&age&sfreq[i])
                     end if
                     draw line (i+.125,lout'arcorrm&age&sfreq[i]+2*lout'arcorrsem&age&sfreq[i]) to (i+.325,lout'arcorrm&age&sfreq[i]+2*lout'arcorrsem&age&sfreq[i])
                  end loop
               end if
            else if exists(lout'corr2m&age&sfreq)
               if exists(lout'stage2agem&sfreq)
                  if (lout'stage2agem&sfreq[age-15] eq 1)
                     data lout'corrm&age&sfreq <batch name "Overall Residual", scolor c13>, &&
                          lout'corr2m&age&sfreq <batch name "2nd stage Innovation", scolor c2>
                     loop for i = 2 to lastvalue(lout'corrsem&age&sfreq)
                        draw line (i-.225,lmax(@left.axis.min,lout'corrm&age&sfreq[i]-2*lout'corrsem&age&sfreq[i])) to &&
                                  (i-.225,lout'corrm&age&sfreq[i]+2*lout'corrsem&age&sfreq[i])
                        if lout'corrm&age&sfreq[i]-2*lout'corrsem&age&sfreq[i] gt @left.axis.min
                           draw line (i-.325,lout'corrm&age&sfreq[i]-2*lout'corrsem&age&sfreq[i]) to (i-.125,lout'corrm&age&sfreq[i]-2*lout'corrsem&age&sfreq[i])
                        end if
                        draw line (i-.325,lout'corrm&age&sfreq[i]+2*lout'corrsem&age&sfreq[i]) to (i-.125,lout'corrm&age&sfreq[i]+2*lout'corrsem&age&sfreq[i])
                        draw line (i+.225,lmax(@left.axis.min,lout'corr2m&age&sfreq[i]-2*lout'corr2sem&age&sfreq[i])) to &&
                                  (i+.225,lout'corr2m&age&sfreq[i]+2*lout'corr2sem&age&sfreq[i])
                        if lout'corr2m&age&sfreq[i]-2*lout'corr2sem&age&sfreq[i] gt @left.axis.min
                           draw line (i+.125,lout'corr2m&age&sfreq[i]-2*lout'corr2sem&age&sfreq[i]) to (i+.325,lout'corr2m&age&sfreq[i]-2*lout'corr2sem&age&sfreq[i])
                        end if
                        draw line (i+.125,lout'corr2m&age&sfreq[i]+2*lout'corr2sem&age&sfreq[i]) to (i+.325,lout'corr2m&age&sfreq[i]+2*lout'corr2sem&age&sfreq[i])
                     end loop
                  else
                     data lout'corrm&age&sfreq <batch name "Overall Residual", scolor c13>
                     loop for i = 2 to lastvalue(lout'corrsem&age&sfreq)
                        draw line (i,lmax(@left.axis.min,lout'corrm&age&sfreq[i]-2*lout'corrsem&age&sfreq[i])) to &&
                                  (i,lout'corrm&age&sfreq[i]+2*lout'corrsem&age&sfreq[i])
                        if lout'corrm&age&sfreq[i]-2*lout'corrsem&age&sfreq[i] gt @left.axis.min
                           draw line (i-.1,lout'corrm&age&sfreq[i]-2*lout'corrsem&age&sfreq[i]) to (i+.1,lout'corrm&age&sfreq[i]-2*lout'corrsem&age&sfreq[i])
                        end if
                        draw line (i-.1,lout'corrm&age&sfreq[i]+2*lout'corrsem&age&sfreq[i]) to (i+.1,lout'corrm&age&sfreq[i]+2*lout'corrsem&age&sfreq[i])
                     end loop
                  end if
               else
                  data lout'corrm&age&sfreq <batch name "Overall Residual", scolor c13>, &&
                       lout'corr2m&age&sfreq <batch name "2nd stage Innovation", scolor c2>
                  loop for i = 2 to lastvalue(lout'corrsem&age&sfreq)
                     draw line (i-.225,lmax(@left.axis.min,lout'corrm&age&sfreq[i]-2*lout'corrsem&age&sfreq[i])) to &&
                               (i-.225,lout'corrm&age&sfreq[i]+2*lout'corrsem&age&sfreq[i])
                     if lout'corrm&age&sfreq[i]-2*lout'corrsem&age&sfreq[i] gt @left.axis.min
                        draw line (i-.325,lout'corrm&age&sfreq[i]-2*lout'corrsem&age&sfreq[i]) to (i-.125,lout'corrm&age&sfreq[i]-2*lout'corrsem&age&sfreq[i])
                     end if
                     draw line (i-.325,lout'corrm&age&sfreq[i]+2*lout'corrsem&age&sfreq[i]) to (i-.125,lout'corrm&age&sfreq[i]+2*lout'corrsem&age&sfreq[i])
                     draw line (i+.225,lmax(@left.axis.min,lout'corr2m&age&sfreq[i]-2*lout'corr2sem&age&sfreq[i])) to &&
                               (i+.225,lout'corr2m&age&sfreq[i]+2*lout'corr2sem&age&sfreq[i])
                     if lout'corr2m&age&sfreq[i]-2*lout'corr2sem&age&sfreq[i] gt @left.axis.min
                        draw line (i+.125,lout'corr2m&age&sfreq[i]-2*lout'corr2sem&age&sfreq[i]) to (i+.325,lout'corr2m&age&sfreq[i]-2*lout'corr2sem&age&sfreq[i])
                     end if
                     draw line (i+.125,lout'corr2m&age&sfreq[i]+2*lout'corr2sem&age&sfreq[i]) to (i+.325,lout'corr2m&age&sfreq[i]+2*lout'corr2sem&age&sfreq[i])
                  end loop
               end if
            else
               data lout'corrm&age&sfreq <batch name "Overall Residual", scolor c13>
               loop for i = 2 to lastvalue(lout'corrsem&age&sfreq)
                  draw line (i,lmax(@left.axis.min,lout'corrm&age&sfreq[i]-2*lout'corrsem&age&sfreq[i])) to &&
                            (i,lout'corrm&age&sfreq[i]+2*lout'corrsem&age&sfreq[i])
                  if lout'corrm&age&sfreq[i]-2*lout'corrsem&age&sfreq[i] gt @left.axis.min
                     draw line (i-.1,lout'corrm&age&sfreq[i]-2*lout'corrsem&age&sfreq[i]) to (i+.1,lout'corrm&age&sfreq[i]-2*lout'corrsem&age&sfreq[i])
                  end if
                  draw line (i-.1,lout'corrm&age&sfreq[i]+2*lout'corrsem&age&sfreq[i]) to (i+.1,lout'corrm&age&sfreq[i]+2*lout'corrsem&age&sfreq[i])
               end loop
            end if
            depict grid on, axis left
            draw marking at 0
         end graph 

         cell(4,1 to 2)
         graph 
            date 1976 to *
            legend appear on, size xsmall, font f10
            legend division rows 1, column auto
            tick left numeric linear (auto to 1 in auto using lin2)
            tick label size xsmall, font f10
            title #1 font f10, size xsmall, text "Residual Partial Autocorrelations (Men, Age "+string(age)+")", color c1
            if exists(lout'arpcorrm&age&sfreq)
               if exists(lout'pcorr2m&age&sfreq)
                  if exists(lout'stage2agem&sfreq)
                     if (lout'stage2agem&sfreq[age-15] eq 1)        
                        data lout'pcorrm&age&sfreq <batch name "Overall Residual", scolor c13>, &&
                             lout'arpcorrm&age&sfreq <batch name "AR(1) Innovation (rho: "+numfmt(lout'rhom&sfreq[age-15],5,3)+")", scolor c4>, &&
                             lout'pcorr2m&age&sfreq <batch name "2nd stage Innovation", scolor c2>
                     else
                        data lout'pcorrm&age&sfreq <batch name "Overall Residual", scolor c13>, &&
                             lout'arpcorrm&age&sfreq <batch name "AR(1) Innovation (rho: "+numfmt(lout'rhom&sfreq[age-15],5,3)+")", scolor c4>
                     end if
                  else
                     data lout'pcorrm&age&sfreq <batch name "Overall Residual", scolor c13>, &&
                          lout'arpcorrm&age&sfreq <batch name "AR(1) Innovation (rho: "+numfmt(lout'rhom&sfreq[age-15],5,3)+")", scolor c4>, &&
                          lout'pcorr2m&age&sfreq <batch name "2nd stage Innovation", scolor c2>
                  end if
               else
                  data lout'pcorrm&age&sfreq <batch name "Overall Residual", scolor c13>, &&
                       lout'arpcorrm&age&sfreq <batch name "AR(1) Innovation (rho: "+numfmt(lout'rhom&sfreq[age-15],5,3)+")", scolor c4>
               end if
            else if exists(lout'pcorr2m&age&sfreq)
               if exists(lout'stage2agem&sfreq)
                  if (lout'stage2agem&sfreq[age-15] eq 1)
                     data lout'pcorrm&age&sfreq <batch name "Overall Residual", scolor c13>, &&
                          lout'pcorr2m&age&sfreq <batch name "2nd stage Innovation", scolor c2>
                  else
                     data lout'pcorrm&age&sfreq <batch name "Overall Residual", scolor c13>
                  end if
               else
                  data lout'pcorrm&age&sfreq <batch name "Overall Residual", scolor c13>, &&
                       lout'pcorr2m&age&sfreq <batch name "2nd stage Innovation", scolor c2>
               end if
            else
               data lout'pcorrm&age&sfreq <batch name "Overall Residual", scolor c13>
            end if
            -local'pcb = 1.96/sqrt((36-lmax(0,16-age+10,age-79+10))*local'per)
            draw line <depict style dashed, color c1, thickness thin> (.5,local'pcb) to (lastvalue(lout'pcorrm&age&sfreq)+.5,local'pcb)
            if -local'pcb gt @left.axis.min
               draw line <depict style dashed, color c1, thickness thin> (.5,-local'pcb) to (lastvalue(lout'pcorrm&age&sfreq)+.5,-local'pcb)
            end if
            depict grid on, axis left
            draw marking at 0
         end graph 

         cell(1,1 to 2)
         graph 
            date 1976 to *
            legend appear on, size xsmall, font f10
            legend division rows 1, column auto
            tick label size xsmall, font f10
            title #1 font f10, size xsmall, text "Raw Residual (Women, Age "+string(age)+")", color c1
            if exists(lout'arresf&age&sfreq)
               if exists(lout'res2f&age&sfreq)
                  if exists(lout'stage2agef&sfreq)
                     if (lout'stage2agef&sfreq[age-15] eq 1)        
                        data lout'resf&age&sfreq <plot name "Overall Residual", color c1>, &&
                             lout'arresf&age&sfreq <plot name "AR(1) Innovation (rho: "+numfmt(lout'rhof&sfreq[age-15],5,3)+")", color c4>, &&
                             lout'res2f&age&sfreq <plot name "2nd stage Innovation", color c2>
                     else
                        data lout'resf&age&sfreq <plot name "Overall Residual", color c1>, &&
                             lout'arresf&age&sfreq <plot name "AR(1) Innovation (rho: "+numfmt(lout'rhof&sfreq[age-15],5,3)+")", color c4>
                     end if
                  else
                     data lout'resf&age&sfreq <plot name "Overall Residual", color c1>, &&
                          lout'arresf&age&sfreq <plot name "AR(1) Innovation (rho: "+numfmt(lout'rhof&sfreq[age-15],5,3)+")", color c4>, &&
                          lout'res2f&age&sfreq <plot name "2nd stage Innovation", color c2>
                  end if
               else
                  data lout'resf&age&sfreq <plot name "Overall Residual", color c1>, &&
                       lout'arresf&age&sfreq <plot name "AR(1) Innovation (rho: "+numfmt(lout'rhof&sfreq[age-15],5,3)+")", color c4>
               end if
            else if exists(lout'res2f&age&sfreq)
               if exists(lout'stage2agef&sfreq)
                  if (lout'stage2agef&sfreq[age-15] eq 1)
                     data lout'resf&age&sfreq <plot name "Overall Residual", color c9, thickness xthin>, &&
                          mave(lout'resf&age&sfreq,local'per) <plot name "Overall Residual (MA "+string(local'per)+"-period)", color c1, thickness thin>, &&
                          lout'res2f&age&sfreq <plot name "2nd stage Innovation", color c16, thickness xthin>, &&
                          mave(lout'res2f&age&sfreq,local'per) <plot name "2nd stage Innovation (MA "+string(local'per)+"-period)", color c2, thickness thin>
                  else
                     data lout'resf&age&sfreq <plot name "Overall Residual", color c9, thickness xthin>, &&
                          mave(lout'resf&age&sfreq,local'per) <plot name "Overall Residual (MA "+string(local'per)+"-period)", color c1, thickness thin>
                  end if
               else
                  data lout'resf&age&sfreq <plot name "Overall Residual", color c9, thickness xthin>, &&
                       mave(lout'resf&age&sfreq,local'per) <plot name "Overall Residual (MA "+string(local'per)+"-period)", color c1, thickness thin>, &&
                       lout'res2f&age&sfreq <plot name "2nd stage Innovation", color c16, thickness xthin>, &&
                       mave(lout'res2f&age&sfreq,local'per) <plot name "2nd stage Innovation (MA "+string(local'per)+"-period)", color c2, thickness thin>
               end if
            else
               data lout'resf&age&sfreq <plot name "Overall Residual", color c9, thickness xthin> , &&
                    mave(lout'resf&age&sfreq,local'per) <plot name "Overall Residual (MA "+string(local'per)+"-period)", color c1, thickness thin>
            end if

            draw region <depict axis bottom, color C8,shading paint; glue dot> lout'end_est&sfreq-lmax((26-age),0)*local'per+1 to 2021:1-1
            draw region <depict axis bottom, color C8,shading paint; glue dot> 1950:1 to lout'start_est&sfreq+lmax((age-69),0)*local'per-1
            draw line <depict axis bottom, color C9, placement beginning; glue dot> &&
               (lout'start_est&sfreq+lmax((age-69),0)*local'per,@left.axis.min) to (lout'start_est&sfreq+lmax((age-69),0)*local'per,@left.axis.max)
            draw line <depict axis bottom, color C9, placement beginning; glue dot> &&
               (lout'end_est&sfreq-lmax((26-age)*local'per,0)+1,@left.axis.min) to (lout'end_est&sfreq-lmax((26-age),0)*local'per+1,@left.axis.max)
            depict grid on, axis left
            draw marking at 0
         end graph   
    
         -local'p1 = (if t lt 1980:1 then lout'resf&age&sfreq else ND)
         -local'p2 = (if t lt 1980:1 then ND else (if t lt 1991:1 then lout'resf&age&sfreq else ND))
         -local'p3 = (if t lt 1991:1 then ND else (if t lt 2002:1 then lout'resf&age&sfreq else ND))
         -local'p4 = (if t lt 2002:1 then ND else (if t lt 2008:1 then lout'resf&age&sfreq else ND))
         -local'p5 = (if t lt 2008:1 then ND else lout'resf&age&sfreq)

         cell(2,1 to 2)
         graph 
            date 1976 to *
            legend appear on, size xsmall, font f10
            legend division rows 2, column auto
            tick label size xsmall, font f10
            title #1 font f10, size xsmall, text "Raw Residual vs. LFPR (Women, Age "+string(age)+")", color c1
            data local'p1 <scatter name "*-'79", color c1, draw eachvalue, symbol scircle>, &&
                 local'p2 <scatter name "'80-'90", color c4, draw eachvalue, symbol scircle>, &&
                 local'p3 <scatter name "'91-'01", color c2, draw eachvalue, symbol scircle>, &&
                 local'p4 <scatter name "'02-'07", color c15, draw eachvalue, symbol scircle>, &&
                 local'p5 <scatter name "'08-*", color c11, draw eachvalue, symbol scircle> &&
                 vs lout'id(lout'lfpname)&_predm&age&sfreq
            depict grid on, axis left
            draw marking at 0
         end graph  

         cell(3,1 to 2)
         graph 
            legend appear on, size xsmall, font f10
            legend division rows 1, column auto
            tick left numeric linear (auto to 1 in auto using lin2)
            tick label size xsmall, font f10
            title #1 font f10, size xsmall, text "Residual Autocorrelations (Women, Age "+string(age)+")", color c1
            if exists(lout'arcorrf&age&sfreq)
               if exists(lout'corr2f&age&sfreq)
                  if exists(lout'stage2agef&sfreq) 
                     if (lout'stage2agef&sfreq[age-15] eq 1)
                        data lout'corrf&age&sfreq <batch name "Overall Residual", scolor c13>, &&
                             lout'arcorrf&age&sfreq <batch name "AR(1) Innovation (rho: "+numfmt(lout'rhof&sfreq[age-15],5,3)+")", scolor c4>, &&
                             lout'corr2f&age&sfreq <batch name "2nd stage Innovation", scolor c2>
                        loop for i = 2 to lastvalue(lout'corrsem&age&sfreq)
                           draw line (i-.3,lmax(@left.axis.min,lout'corrf&age&sfreq[i]-2*lout'corrsef&age&sfreq[i])) to &&
                                     (i-.3,lout'corrf&age&sfreq[i]+2*lout'corrsef&age&sfreq[i])
                           if lout'corrf&age&sfreq[i]-2*lout'corrsef&age&sfreq[i] gt @left.axis.min
                              draw line (i-.4,lout'corrf&age&sfreq[i]-2*lout'corrsef&age&sfreq[i]) to (i-.2,lout'corrf&age&sfreq[i]-2*lout'corrsef&age&sfreq[i])
                           end if
                           draw line (i-.4,lout'corrf&age&sfreq[i]+2*lout'corrsef&age&sfreq[i]) to (i-.2,lout'corrf&age&sfreq[i]+2*lout'corrsef&age&sfreq[i])
                           draw line (i,lmax(@left.axis.min,lout'arcorrf&age&sfreq[i]-2*lout'arcorrsef&age&sfreq[i])) to &&
                                     (i,lout'arcorrf&age&sfreq[i]+2*lout'arcorrsef&age&sfreq[i])
                           if lout'arcorrf&age&sfreq[i]-2*lout'arcorrsef&age&sfreq[i] gt @left.axis.min
                              draw line (i-.1,lout'arcorrf&age&sfreq[i]-2*lout'arcorrsef&age&sfreq[i]) to (i+.1,lout'arcorrf&age&sfreq[i]-2*lout'arcorrsef&age&sfreq[i])
                           end if
                           draw line (i-.1,lout'arcorrf&age&sfreq[i]+2*lout'arcorrsef&age&sfreq[i]) to (i+.1,lout'arcorrf&age&sfreq[i]+2*lout'arcorrsef&age&sfreq[i])
                           draw line (i+.3,lmax(@left.axis.min,lout'corr2f&age&sfreq[i]-2*lout'corr2sef&age&sfreq[i])) to &&
                                     (i+.3,lout'corr2f&age&sfreq[i]+2*lout'corr2sef&age&sfreq[i])
                           if lout'corr2f&age&sfreq[i]-2*lout'corr2sef&age&sfreq[i] gt @left.axis.min
                              draw line (i+.2,lout'corr2f&age&sfreq[i]-2*lout'corr2sef&age&sfreq[i]) to (i+.4,lout'corr2f&age&sfreq[i]-2*lout'corr2sef&age&sfreq[i])
                           end if
                           draw line (i+.2,lout'corr2f&age&sfreq[i]+2*lout'corr2sef&age&sfreq[i]) to (i+.4,lout'corr2f&age&sfreq[i]+2*lout'corr2sef&age&sfreq[i])
                        end loop
                     else
                        data lout'corrf&age&sfreq <batch name "Overall Residual", scolor c13>, &&
                             lout'arcorrf&age&sfreq <batch name "AR(1) Innovation (rho: "+numfmt(lout'rhof&sfreq[age-15],5,3)+")", scolor c4>
                        loop for i = 2 to lastvalue(lout'corrsem&age&sfreq)
                           draw line (i-.225,lmax(@left.axis.min,lout'corrf&age&sfreq[i]-2*lout'corrsef&age&sfreq[i])) to &&
                                     (i-.225,lout'corrf&age&sfreq[i]+2*lout'corrsef&age&sfreq[i])
                           if lout'corrf&age&sfreq[i]-2*lout'corrsef&age&sfreq[i] gt @left.axis.min
                              draw line (i-.325,lout'corrf&age&sfreq[i]-2*lout'corrsef&age&sfreq[i]) to (i-.125,lout'corrf&age&sfreq[i]-2*lout'corrsef&age&sfreq[i])
                           end if
                           draw line (i-.325,lout'corrf&age&sfreq[i]+2*lout'corrsef&age&sfreq[i]) to (i-.125,lout'corrf&age&sfreq[i]+2*lout'corrsef&age&sfreq[i])
                           draw line (i+.225,lmax(@left.axis.min,lout'arcorrf&age&sfreq[i]-2*lout'arcorrsef&age&sfreq[i])) to &&
                                     (i+.225,lout'arcorrf&age&sfreq[i]+2*lout'arcorrsef&age&sfreq[i])
                           if lout'arcorrf&age&sfreq[i]-2*lout'arcorrsef&age&sfreq[i] gt @left.axis.min
                              draw line (i+.125,lout'arcorrf&age&sfreq[i]-2*lout'arcorrsef&age&sfreq[i]) to (i+.325,lout'arcorrf&age&sfreq[i]-2*lout'arcorrsef&age&sfreq[i])
                           end if
                           draw line (i+.125,lout'arcorrf&age&sfreq[i]+2*lout'arcorrsef&age&sfreq[i]) to (i+.325,lout'arcorrf&age&sfreq[i]+2*lout'arcorrsef&age&sfreq[i])
                        end loop
                     end if
                  else
                     data lout'corrf&age&sfreq <batch name "Overall Residual", scolor c13>, &&
                          lout'arcorrf&age&sfreq <batch name "AR(1) Innovation (rho: "+numfmt(lout'rhof&sfreq[age-15],5,3)+")", scolor c4>, &&
                          lout'corr2f&age&sfreq <batch name "2nd stage Innovation", scolor c2>
                     loop for i = 2 to lastvalue(lout'corrsem&age&sfreq)
                        draw line (i-.3,lmax(@left.axis.min,lout'corrf&age&sfreq[i]-2*lout'corrsef&age&sfreq[i])) to &&
                                  (i-.3,lout'corrf&age&sfreq[i]+2*lout'corrsef&age&sfreq[i])
                        if lout'corrf&age&sfreq[i]-2*lout'corrsef&age&sfreq[i] gt @left.axis.min
                           draw line (i-.4,lout'corrf&age&sfreq[i]-2*lout'corrsef&age&sfreq[i]) to (i-.2,lout'corrf&age&sfreq[i]-2*lout'corrsef&age&sfreq[i])
                        end if
                        draw line (i-.4,lout'corrf&age&sfreq[i]+2*lout'corrsef&age&sfreq[i]) to (i-.2,lout'corrf&age&sfreq[i]+2*lout'corrsef&age&sfreq[i])
                        draw line (i,lmax(@left.axis.min,lout'arcorrf&age&sfreq[i]-2*lout'arcorrsef&age&sfreq[i])) to &&
                                  (i,lout'arcorrf&age&sfreq[i]+2*lout'arcorrsef&age&sfreq[i])
                        if lout'arcorrf&age&sfreq[i]-2*lout'arcorrsef&age&sfreq[i] gt @left.axis.min
                           draw line (i-.1,lout'arcorrf&age&sfreq[i]-2*lout'arcorrsef&age&sfreq[i]) to (i+.1,lout'arcorrf&age&sfreq[i]-2*lout'arcorrsef&age&sfreq[i])
                        end if
                        draw line (i-.1,lout'arcorrf&age&sfreq[i]+2*lout'arcorrsef&age&sfreq[i]) to (i+.1,lout'arcorrf&age&sfreq[i]+2*lout'arcorrsef&age&sfreq[i])
                        draw line (i+.3,lmax(@left.axis.min,lout'corr2f&age&sfreq[i]-2*lout'corr2sef&age&sfreq[i])) to &&
                                  (i+.3,lout'corr2f&age&sfreq[i]+2*lout'corr2sef&age&sfreq[i])
                        if lout'corr2f&age&sfreq[i]-2*lout'corr2sef&age&sfreq[i] gt @left.axis.min
                           draw line (i+.2,lout'corr2f&age&sfreq[i]-2*lout'corr2sef&age&sfreq[i]) to (i+.4,lout'corr2f&age&sfreq[i]-2*lout'corr2sef&age&sfreq[i])
                        end if
                        draw line (i+.2,lout'corr2f&age&sfreq[i]+2*lout'corr2sef&age&sfreq[i]) to (i+.4,lout'corr2f&age&sfreq[i]+2*lout'corr2sef&age&sfreq[i])
                     end loop
                  end if
               else
                  data lout'corrf&age&sfreq <batch name "Overall Residual", scolor c13>, &&
                       lout'arcorrf&age&sfreq <batch name "AR(1) Innovation (rho: "+numfmt(lout'rhof&sfreq[age-15],5,3)+")", scolor c4>
                  loop for i = 2 to lastvalue(lout'corrsem&age&sfreq)
                     draw line (i-.225,lmax(@left.axis.min,lout'corrf&age&sfreq[i]-2*lout'corrsef&age&sfreq[i])) to &&
                               (i-.225,lout'corrf&age&sfreq[i]+2*lout'corrsef&age&sfreq[i])
                     if lout'corrf&age&sfreq[i]-2*lout'corrsef&age&sfreq[i] gt @left.axis.min
                        draw line (i-.325,lout'corrf&age&sfreq[i]-2*lout'corrsef&age&sfreq[i]) to (i-.125,lout'corrf&age&sfreq[i]-2*lout'corrsef&age&sfreq[i])
                     end if
                     draw line (i-.325,lout'corrf&age&sfreq[i]+2*lout'corrsef&age&sfreq[i]) to (i-.125,lout'corrf&age&sfreq[i]+2*lout'corrsef&age&sfreq[i])
                     draw line (i+.225,lmax(@left.axis.min,lout'arcorrf&age&sfreq[i]-2*lout'arcorrsef&age&sfreq[i])) to &&
                               (i+.225,lout'arcorrf&age&sfreq[i]+2*lout'arcorrsef&age&sfreq[i])
                     if lout'arcorrf&age&sfreq[i]-2*lout'arcorrsef&age&sfreq[i] gt @left.axis.min
                        draw line (i+.125,lout'arcorrf&age&sfreq[i]-2*lout'arcorrsef&age&sfreq[i]) to (i+.325,lout'arcorrf&age&sfreq[i]-2*lout'arcorrsef&age&sfreq[i])
                     end if
                     draw line (i+.125,lout'arcorrf&age&sfreq[i]+2*lout'arcorrsef&age&sfreq[i]) to (i+.325,lout'arcorrf&age&sfreq[i]+2*lout'arcorrsef&age&sfreq[i])
                  end loop
               end if
            else if exists(lout'corr2f&age&sfreq)
               if exists(lout'stage2agef&sfreq)
                  if (lout'stage2agef&sfreq[age-15] eq 1)
                     data lout'corrf&age&sfreq <batch name "Overall Residual", scolor c13>, &&
                          lout'corr2f&age&sfreq <batch name "2nd stage Innovation", scolor c2>
                     loop for i = 2 to lastvalue(lout'corrsem&age&sfreq)
                        draw line (i-.225,lmax(@left.axis.min,lout'corrf&age&sfreq[i]-2*lout'corrsef&age&sfreq[i])) to &&
                                  (i-.225,lout'corrf&age&sfreq[i]+2*lout'corrsef&age&sfreq[i])
                        if lout'corrf&age&sfreq[i]-2*lout'corrsef&age&sfreq[i] gt @left.axis.min
                           draw line (i-.325,lout'corrf&age&sfreq[i]-2*lout'corrsef&age&sfreq[i]) to (i-.125,lout'corrf&age&sfreq[i]-2*lout'corrsef&age&sfreq[i])
                        end if
                        draw line (i-.325,lout'corrf&age&sfreq[i]+2*lout'corrsef&age&sfreq[i]) to (i-.125,lout'corrf&age&sfreq[i]+2*lout'corrsef&age&sfreq[i])
                        draw line (i+.225,lmax(@left.axis.min,lout'corr2f&age&sfreq[i]-2*lout'corr2sef&age&sfreq[i])) to &&
                                  (i+.225,lout'corr2f&age&sfreq[i]+2*lout'corr2sef&age&sfreq[i])
                        if lout'corr2f&age&sfreq[i]-2*lout'corr2sef&age&sfreq[i] gt @left.axis.min
                           draw line (i+.125,lout'corr2f&age&sfreq[i]-2*lout'corr2sef&age&sfreq[i]) to (i+.325,lout'corr2f&age&sfreq[i]-2*lout'corr2sef&age&sfreq[i])
                        end if
                        draw line (i+.125,lout'corr2f&age&sfreq[i]+2*lout'corr2sef&age&sfreq[i]) to (i+.325,lout'corr2f&age&sfreq[i]+2*lout'corr2sef&age&sfreq[i])
                     end loop
                  else
                     data lout'corrf&age&sfreq <batch name "Overall Residual", scolor c13>
                     loop for i = 2 to lastvalue(lout'corrsem&age&sfreq)
                        draw line (i,lmax(@left.axis.min,lout'corrf&age&sfreq[i]-2*lout'corrsef&age&sfreq[i])) to &&
                                  (i,lout'corrf&age&sfreq[i]+2*lout'corrsef&age&sfreq[i])
                        if lout'corrf&age&sfreq[i]-2*lout'corrsef&age&sfreq[i] gt @left.axis.min
                           draw line (i-.1,lout'corrf&age&sfreq[i]-2*lout'corrsef&age&sfreq[i]) to (i+.1,lout'corrf&age&sfreq[i]-2*lout'corrsef&age&sfreq[i])
                        end if
                        draw line (i-.1,lout'corrf&age&sfreq[i]+2*lout'corrsef&age&sfreq[i]) to (i+.1,lout'corrf&age&sfreq[i]+2*lout'corrsef&age&sfreq[i])
                     end loop
                  end if
               else
                  data lout'corrf&age&sfreq <batch name "Overall Residual", scolor c13>, &&
                       lout'corr2f&age&sfreq <batch name "2nd stage Innovation", scolor c2>
                  loop for i = 2 to lastvalue(lout'corrsem&age&sfreq)
                     draw line (i-.225,lmax(@left.axis.min,lout'corrf&age&sfreq[i]-2*lout'corrsef&age&sfreq[i])) to &&
                               (i-.225,lout'corrf&age&sfreq[i]+2*lout'corrsef&age&sfreq[i])
                     if lout'corrf&age&sfreq[i]-2*lout'corrsef&age&sfreq[i] gt @left.axis.min
                        draw line (i-.325,lout'corrf&age&sfreq[i]-2*lout'corrsef&age&sfreq[i]) to (i-.125,lout'corrf&age&sfreq[i]-2*lout'corrsef&age&sfreq[i])
                     end if
                     draw line (i-.325,lout'corrf&age&sfreq[i]+2*lout'corrsef&age&sfreq[i]) to (i-.125,lout'corrf&age&sfreq[i]+2*lout'corrsef&age&sfreq[i])
                     draw line (i+.225,lmax(@left.axis.min,lout'corr2f&age&sfreq[i]-2*lout'corr2sef&age&sfreq[i])) to &&
                               (i+.225,lout'corr2f&age&sfreq[i]+2*lout'corr2sef&age&sfreq[i])
                     if lout'corr2f&age&sfreq[i]-2*lout'corr2sef&age&sfreq[i] gt @left.axis.min
                        draw line (i+.125,lout'corr2f&age&sfreq[i]-2*lout'corr2sef&age&sfreq[i]) to (i+.325,lout'corr2f&age&sfreq[i]-2*lout'corr2sef&age&sfreq[i])
                     end if
                     draw line (i+.125,lout'corr2f&age&sfreq[i]+2*lout'corr2sef&age&sfreq[i]) to (i+.325,lout'corr2f&age&sfreq[i]+2*lout'corr2sef&age&sfreq[i])
                  end loop
               end if
            else
               data lout'corrf&age&sfreq <batch name "Overall Residual", scolor c13>
               loop for i = 2 to lastvalue(lout'corrsem&age&sfreq)
                  draw line (i-.3,lmax(@left.axis.min,lout'corrf&age&sfreq[i]-2*lout'corrsef&age&sfreq[i])) to &&
                            (i,lout'corrf&age&sfreq[i]+2*lout'corrsef&age&sfreq[i])
                  if lout'corrf&age&sfreq[i]-2*lout'corrsef&age&sfreq[i] gt @left.axis.min
                     draw line (i-.1,lout'corrf&age&sfreq[i]-2*lout'corrsef&age&sfreq[i]) to (i+.1,lout'corrf&age&sfreq[i]-2*lout'corrsef&age&sfreq[i])
                  end if
                  draw line (i-.1,lout'corrf&age&sfreq[i]+2*lout'corrsef&age&sfreq[i]) to (i+.1,lout'corrf&age&sfreq[i]+2*lout'corrsef&age&sfreq[i])
               end loop
            end if
            depict grid on, axis left
            draw marking at 0
         end graph   

         cell(4,1 to 2)
         graph 
            legend appear on, size xsmall, font f10
            legend division rows 1, column auto
            tick left numeric linear (auto to 1 in auto using lin2)
            tick label size xsmall, font f10
            title #1 font f10, size xsmall, text "Residual Partial Autocorrelations (Women, Age "+string(age)+")", color c1
            if exists(lout'arpcorrf&age&sfreq)
               if exists(lout'pcorr2f&age&sfreq)
                  if exists(lout'stage2agef&sfreq)        
                     if (lout'stage2agef&sfreq[age-15] eq 1)
                        data lout'pcorrf&age&sfreq <batch name "Overall Residual", scolor c13>, &&
                             lout'arpcorrf&age&sfreq <batch name "AR(1) Innovation (rho: "+numfmt(lout'rhof&sfreq[age-15],5,3)+")", scolor c4>, &&
                             lout'pcorr2f&age&sfreq <batch name "2nd stage Innovation", scolor c2>
                     else
                        data lout'pcorrf&age&sfreq <batch name "Overall Residual", scolor c13>, &&
                             lout'arpcorrf&age&sfreq <batch name "AR(1) Innovation (rho: "+numfmt(lout'rhof&sfreq[age-15],5,3)+")", scolor c4>
                     end if
                  else
                     data lout'pcorrf&age&sfreq <batch name "Overall Residual", scolor c13>, &&
                          lout'arpcorrf&age&sfreq <batch name "AR(1) Innovation (rho: "+numfmt(lout'rhof&sfreq[age-15],5,3)+")", scolor c4>, &&
                          lout'pcorr2f&age&sfreq <batch name "2nd stage Innovation", scolor c2>
                  end if
               else
                  data lout'pcorrf&age&sfreq <batch name "Overall Residual", scolor c13>, &&
                       lout'arpcorrf&age&sfreq <batch name "AR(1) Innovation (rho: "+numfmt(lout'rhof&sfreq[age-15],5,3)+")", scolor c4>
               end if
            else if exists(lout'pcorr2f&age&sfreq)
               if exists(lout'stage2agef&sfreq)
                  if (lout'stage2agef&sfreq[age-15] eq 1)
                     data lout'pcorrf&age&sfreq <batch name "Overall Residual", scolor c13>, &&
                          lout'pcorr2f&age&sfreq <batch name "2nd stage Innovation", scolor c2>
                  else
                     data lout'pcorrf&age&sfreq <batch name "Overall Residual", scolor c13>
                  end if
               else
                  data lout'pcorrf&age&sfreq <batch name "Overall Residual", scolor c13>, &&
                       lout'pcorr2f&age&sfreq <batch name "2nd stage Innovation", scolor c2>
               end if
            else
               data lout'pcorrf&age&sfreq <batch name "Overall Residual", scolor c13>
            end if

            -local'pcb = 1.96/sqrt((36-lmax(0,16-age+10,age-79+10))*local'per)
            draw line <depict style dashed, color c1, thickness thin> (.5,local'pcb) to (lastvalue(lout'pcorrm&age&sfreq)+.5,local'pcb)
            if -local'pcb gt @left.axis.min
               draw line <depict style dashed, color c1, thickness thin> (.5,-local'pcb) to (lastvalue(lout'pcorrm&age&sfreq)+.5,-local'pcb)
            end if
            depict grid on, axis left
            draw marking at 0
         end graph   

      end loop

      close ageresids.ps
      execute "!(ps2pdf run"+local'runno+"resraw_"+name(sfreq)+".ps; "+&&
                "gv run"+local'runno+"resraw_"+name(sfreq)+".ps; "+&&
                "rm -f run"+local'runno+"resraw_"+name(sfreq)+".ps)&"

      cell(auto,auto)

      page divi rows 4, columns 2
      open <ac over; kind graphic> file("run"+local'runno+"res2_"+name(sfreq)+".ps") as res2.ps
      channel graphics res2.ps

      block
         date 1963 to *
         order 4; order region 1,lines 2, markings 3, series 5
         thickness xthin 1, thin 3, medium 5, thick 7, xthick 9 
         plot color #1 C5, #2 C2, #3 C4
         plot style #1 solid, #2 solid, #3 solid
         plot thickness #1 xthin, #2 medium, #3 xthin    

         legend size xsmall, fill horizontal
         legend division row 1, column auto
         legend color c1
         legend size xsmall

         loop for grpx = 1 to lastvalue(local'agelower)
            -local'thisgroup = "a"+string(local'agelower[grpx])+(if ageupper[grpx] EQ 80 then "P" else "t"+string(ageupper[grpx]))

            -local'tagg = 100*(todb'id(lout'lfpname+"m_"+thisgroup+local'ssfreq)*todb'id("grppopm_"+thisgroup+name(sfreq))+ &&
                               todb'id(lout'lfpname+"f_"+thisgroup+local'ssfreq)*todb'id("grppopf_"+thisgroup+name(sfreq)))/ &&
                              (todb'id("grppopm_"+thisgroup+name(sfreq))+todb'id("grppopf_"+thisgroup+name(sfreq)))
            -local'tmod = 100*(todb'id("modm_"+thisgroup+name(sfreq))*todb'id("grppopm_"+thisgroup+name(sfreq))+ &&
                               todb'id("modf_"+thisgroup+name(sfreq))*todb'id("grppopf_"+thisgroup+name(sfreq)))/ &&
                              (todb'id("grppopm_"+thisgroup+name(sfreq))+todb'id("grppopf_"+thisgroup+name(sfreq)))
            -local'tpred = 100*(todb'id("predm_"+thisgroup+name(sfreq))*todb'id("grppopm_"+thisgroup+name(sfreq))+ &&
                                todb'id("predf_"+thisgroup+name(sfreq))*todb'id("grppopf_"+thisgroup+name(sfreq)))/ &&
                               (todb'id("grppopm_"+thisgroup+name(sfreq))+todb'id("grppopf_"+thisgroup+name(sfreq)))
            cell(1,1 to 2)
            graph 
               date 1976 to *
               title #1 size med, text "Aggregated LFPR ("+thisgroup+")", color c1
               data local'tagg <plot name "Actual">, &&
                    local'tmod <plot name "Model Trend">, &&
                    local'tpred <plot name "Fitted/Simulated">
               draw region <depict axis bottom, color C7,shading paint; glue dot> lout'end_est&sfreq+1 to lout'end_frcst&sfreq+1
               draw region <depict axis bottom, color C8,shading paint; glue dot> lout'end_frcst&sfreq+1 to 2021:1-1
               draw region <depict axis bottom, color C8,shading paint; glue dot> 1950:1 to lout'start_est&sfreq-1
               draw line <depict axis bottom, color C9, placement beginning; glue dot> &&
                  (lout'start_est&sfreq,@left.axis.min) to (lout'start_est&sfreq,@left.axis.max)
               draw line <depict axis bottom, color C9, placement beginning; glue dot> &&
                  (lout'end_est&sfreq+1,@left.axis.min) to (lout'end_est&sfreq+1,@left.axis.max)
               draw line <depict axis bottom, color C9, placement beg; glue dot> &&
                  (lout'end_frcst&sfreq+1,@left.axis.min) to (lout'end_frcst&sfreq+1,@left.axis.max)
            end graph

            cell(2, 1 to 2)
            graph 
               date 1976 to *
               legend appear off
               title #1 size med, text "Cyclical Component ("+thisgroup+")", color c1
               data local'tpred-local'tmod <plot color c1>
               draw region <depict axis bottom, color C7,shading paint; glue dot> lout'end_est&sfreq+1 to lout'end_frcst&sfreq+1
               draw region <depict axis bottom, color C8,shading paint; glue dot> lout'end_frcst&sfreq+1 to 2021:1-1
               draw region <depict axis bottom, color C8,shading paint; glue dot> 1950:1 to lout'start_est&sfreq-1
               draw line <depict axis bottom, color C9, placement beginning; glue dot> &&
                  (lout'start_est&sfreq,@left.axis.min) to (lout'start_est&sfreq,@left.axis.max)
               draw line <depict axis bottom, color C9, placement beginning; glue dot> &&
                  (lout'end_est&sfreq+1,@left.axis.min) to (lout'end_est&sfreq+1,@left.axis.max)
               draw line <depict axis bottom, color C9, placement beg; glue dot> &&
                  (lout'end_frcst&sfreq+1,@left.axis.min) to (lout'end_frcst&sfreq+1,@left.axis.max)
               draw line <depict color c9> (firstdate,0) to (lastvalue(local'tagg),0)
            end graph

            cell(3,1 to 2)
            graph 
               date 1976 to *
               plot thickness thin
               legend appear on
               title #1 size med, text "Residual ("+thisgroup+")", color c1
               data local'tagg-local'tpred <plot name "Residual", color c1>

               draw region <depict axis bottom, color C7,shading paint; glue dot> lout'end_est&sfreq+1 to lout'end_frcst&sfreq+1
               draw region <depict axis bottom, color C8,shading paint; glue dot> lout'end_frcst&sfreq+1 to 2021:1-1
               draw region <depict axis bottom, color C8,shading paint; glue dot> 1950:1 to lout'start_est&sfreq-1
               draw line <depict axis bottom, color C9, placement beginning; glue dot> &&
                  (lout'start_est&sfreq,@left.axis.min) to (lout'start_est&sfreq,@left.axis.max)
               draw line <depict axis bottom, color C9, placement beginning; glue dot> &&
                  (lout'end_est&sfreq+1,@left.axis.min) to (lout'end_est&sfreq+1,@left.axis.max)
               draw line <depict axis bottom, color C9, placement beg; glue dot> &&
                  (lout'end_frcst&sfreq+1,@left.axis.min) to (lout'end_frcst&sfreq+1,@left.axis.max)
               draw line <depict color c9> (firstdate,0) to (lastvalue(local'tagg),0)
            end graph

            local'chisq05_n24 = 36.42
            local'chisq01_n24 = 42.98

            local'chisq05_n8 = 15.51
            local'chisq01_n8 = 20.09

            type "FIT FOR "+local'thisgroup+" (Full range)"
            date lout'start_est&"."&sfreq to lout'end_est&"."&sfreq
            fit <intercept off> (local'tagg-local'tpred) by (local'tagg[t-1]-local'tpred[t-1])
            correlate <keep corr, root c, db local; offset 2*local'per> (local'tagg-local'tpred)
            correlate <keep corr, root p, db local; offset 2*local'per; partial on> (local'tagg-local'tpred)

            type "FIT FOR "+local'thisgroup+" (Narrow range)"
            date (lout'start_est&"."&sfreq+10*local'per) to (lout'end_est&"."&sfreq-10*local'per)
            fit <intercept off> (local'tagg-local'tpred) by (local'tagg[t-1]-local'tpred[t-1])
            correlate <keep corr, root c2, db local; offset 2*local'per> (local'tagg-local'tpred)
            correlate <keep corr, root p2, db local; offset 2*local'per; partial on> (local'tagg-local'tpred)

            block 
               case 1 to 2*local'per
               series local'ccorr_se:precision indexed by case
               series local'c2corr_se:precision indexed by case

               date lout'start_est&"."&sfreq to lout'end_est&"."&sfreq
               which not missing(local'tagg-local'tpred)

               local'ljun_box = lengthdate*(lengthdate+2)*sum(local'ccorr**2/(series(lengthdate,CASE)-n))
               set local'ccorr_se[1] = 1/sqrt(lengthdate)
               loop for i=2 to 2*local'per
                  case 1 to (i-1)
                  set local'ccorr_se[i] = sqrt((1+2*sum(local'ccorr**2))/lengthdate)
               end loop

               date (lout'start_est&"."&sfreq+10*local'per) to (lout'end_est&"."&sfreq-10*local'per)
               which not missing(local'tagg-local'tpred)

               local'ljun_box2 = lengthdate*(lengthdate+2)*sum(local'c2corr**2/(series(lengthdate,CASE)-n))
               set local'c2corr_se[1] = 1/sqrt(lengthdate)
               loop for i=2 to 2*local'per
                  case 1 to (i-1)
                  set local'c2corr_se[i] = sqrt((1+2*sum(local'c2corr**2))/lengthdate)
               end loop
            end block
            

            cell(4,1)
            graph 
               image case axis "<N>"
               legend appear on
               tick left numeric linear (auto to 1 in auto using lin2)
               tick label size xsmall, font f10
               title #1 font f10, size xsmall, text "Residual Autocorrelations", color c1
               title #2 font f10, size xsmall, text "(%5 = "+string(local'id("chisq05_n"+string(2*local'per)))+"; 1% = "+&&
                                                             string(local'id("chisq01_n"+string(2*local'per)))+")"
               data local'ccorr <batch name "All (Ljung-Box = "+string(local'ljun_box)+")", scolor c13>, &&
                    local'c2corr <batch name "Est (Ljung-Box = "+string(local'ljun_box2)+")", scolor c7>, &&
                    2*local'ccorr_se <batch color c1, style solid, draw line, legend off>, &&
                    -2*local'ccorr_se <batch color c1, style solid, draw line, legend off>, &&
                    2*local'c2corr_se <batch color c4, style solid, draw line, legend off>, &&
                    -2*local'c2corr_se <batch color c4, style solid, draw line, legend off>

               depict grid on, axis left
               draw marking at 0
            end graph 

            cell(4,2)
            graph 
               image case axis "<N>"
               legend appear on
               tick left numeric linear (auto to 1 in auto using lin2)
               tick label size xsmall, font f10
               title #1 font f10, size xsmall, text "Residual Partial Autocorrelations", color c1
               data local'ppcorr <batch name "All", scolor c13>, &&
                    local'p2pcorr <batch name "All", scolor c7>

               depict grid on, axis left
               draw marking at 0
            end graph 

         end loop

         cell(auto,auto)


         close res2.ps
         execute "!(ps2pdf run"+local'runno+"res2_"+name(sfreq)+".ps; "+ &&
                   "gv run"+local'runno+"res2_"+name(sfreq)+".ps; "+ &&
                   "rm -f run"+local'runno+"res2_"+name(sfreq)+".ps)&"

      end block

   end loop -- freq loop

   if (not missing(location(@open.db,"TODB")))
      close todb
      system "rm -f "+trim(local'filename)
   end if

   if local'loutopened
      close lout
   end if

   if local'cpsrevopened
      close cpsrev
   end if

end block
end procedure
